/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

public class MibAccess {
    public static final int UNKNOWN = 0;
    public static final int NOTACCESSIBLE = 1;
    public static final int READONLY = 2;
    public static final int WRITEONLY = 3;
    public static final int READWRITE = 4;
    public static final int READCREATE = 5;
    public static final int FORNOTIFY = 6;
    public static final String S_UNKNOWN = "unknown";
    public static final String S_NOTACCESSIBLE = "not-accessible";
    public static final String S_READONLY = "read-only";
    public static final String S_WRITEONLY = "write-only";
    public static final String S_READWRITE = "read-write";
    public static final String S_READCREATE = "read-create";
    public static final String S_FORNOTIFY = "accessible-for-notify";

    public static String toString(int n) {
        switch (n) {
            case 1: {
                return S_NOTACCESSIBLE;
            }
            case 2: {
                return S_READONLY;
            }
            case 4: {
                return S_READWRITE;
            }
            case 3: {
                return S_WRITEONLY;
            }
            case 5: {
                return S_READCREATE;
            }
            case 6: {
                return S_FORNOTIFY;
            }
        }
        return S_UNKNOWN;
    }

    public static int fromString(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals(S_NOTACCESSIBLE)) {
            return 1;
        }
        if (string.equals(S_READONLY)) {
            return 2;
        }
        if (string.equals(S_WRITEONLY)) {
            return 3;
        }
        if (string.equals(S_READWRITE)) {
            return 4;
        }
        if (string.equals(S_READCREATE)) {
            return 5;
        }
        if (string.equals(S_FORNOTIFY)) {
            return 6;
        }
        return 0;
    }

    public static boolean allowsRead(int n) {
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 4: {
                return true;
            }
            case 3: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean allowsWrite(int n) {
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                return true;
            }
            case 3: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return false;
            }
        }
        return false;
    }

    public static boolean allowsCreate(int n) {
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                return false;
            }
            case 3: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return false;
            }
        }
        return false;
    }
}

